#ifndef JPEGMEM_H
#define JPEGMEM_H

#include <stdio.h>
#include <stdlib.h>
#include <jpeglib.h>

typedef struct {
  struct jpeg_source_mgr pub;	/* public fields */
  JOCTET * buffer;
  unsigned long buffer_length;
} memory_source_mgr;

typedef struct {
  struct jpeg_destination_mgr pub;
  JOCTET * buffer; 
  unsigned long buffer_length;
} memory_destination_mgr;

typedef memory_source_mgr *memory_src_ptr;
typedef memory_destination_mgr *memory_dst_ptr;

int
jpeg_encode(const unsigned char * const src,
	    const int width, const int height,
	    const unsigned char * const dst,
	    const int quality );
/*
  src: buffer of R, G, B 
  dst: buffer of jpeg image
  quality: 0 to 100 (%)
*/

int
jpeg_decode( unsigned char * mem_src,		 
	     unsigned char * mem_dst,
	     int width, int height );

/*
  src: buffer of jpeg image
  dst: buffer of R, G, B 
*/

#endif
