#include "jpegmem.h"

int main(){
  
  char header[3];
  int width, height;
  int depth;

  int encoded_size;
  
  unsigned char * ppm_img_1;
  unsigned char * jpg_img;
  unsigned char * ppm_img_2;
  
  FILE *fp[3];

  fp[0] = fopen("sample1.ppm", "rb");

  /** read ppm image **/
  fscanf(fp[0], "%s\n", header);
  fscanf(fp[0], "%d %d\n", &width, &height);
  fscanf(fp[0], "%d\n", &depth);
  ppm_img_1 = (unsigned char *)malloc(width * height * 3);
  fread(ppm_img_1, width * height * 3, 1, fp[0]);
  fclose(fp[0]);

  /** show info of input ppm image **/
  fprintf(stderr, "%s\n", header);
  fprintf(stderr, "%d %d\n", width, height);
  fprintf(stderr, "%d\n", depth);

  jpg_img = (unsigned char *)malloc(width * height * 3);
  encoded_size = jpeg_encode(ppm_img_1, width, height, jpg_img, 50);

  fp[1] = fopen("sample.jpg", "wb");
  fwrite(jpg_img, encoded_size, 1, fp[1]);
  fclose(fp[1]);

  ppm_img_2 = (unsigned char *)malloc(width * height * 3);
  jpeg_decode(jpg_img, ppm_img_2, width, height);
  
  fp[2] = fopen("sample2.ppm", "wb");
  fprintf(fp[2], "%s\n", header);
  fprintf(fp[2], "%d %d\n", width, height);
  fprintf(fp[2], "%d\n", depth);
  fwrite(ppm_img_2, width * height * 3, 1, fp[2]);
  fclose(fp[2]);

  free(ppm_img_1);
  free(jpg_img);
  free(ppm_img_2);

  return 0;
}
